## Why is this an issue?

When creating a custom [Markup Extension](https://learn.microsoft.com/en-us/dotnet/desktop/wpf/advanced/markup-extensions-and-wpf-xaml)
that accepts parameters in WPF, the [`ConstructorArgument`](https://learn.microsoft.com/en-us/dotnet/api/system.windows.markup.constructorargumentattribute) markup
must be used to identify the discrete properties that match these parameters. However since this is done via a string, the compiler won’t give you any
warning in case there are typos.

This rule raises an issue when the string argument to `ConstructorArgumentAttribute` doesn’t match any parameter of any constructor.

## How to fix it

### Code examples

#### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
      public class MyExtension : MarkupExtension
      {
        public MyExtension() { }
    
        public MyExtension(object value1)
        {
          Value1 = value1;
        }
    
        [ConstructorArgument("value2")]   // Noncompliant
        public object Value1 { get; set; }
      }
    }

#### Compliant solution

    using System;
    
    namespace MyLibrary
    {
      public class MyExtension : MarkupExtension
      {
        public MyExtension() { }
    
        public MyExtension(object value1)
        {
          Value1 = value1;
        }
    
        [ConstructorArgument("value1")]
        public object Value1 { get; set; }
      }
    }

## Resources

### Documentation

- Microsoft Learn - [Markup Extensions and
  WPF XAML](https://learn.microsoft.com/en-us/dotnet/desktop/wpf/advanced/markup-extensions-and-wpf-xaml)
- Microsoft Learn - [MarkupExtension Class](https://learn.microsoft.com/en-us/dotnet/api/system.windows.markup.markupextension)
- Microsoft Learn - [ConstructorArgumentAttribute Class](https://learn.microsoft.com/en-us/dotnet/api/system.windows.markup.constructorargumentattribute)