## Why is this an issue?

When raising an event, two arguments are expected by the `EventHandler` delegate: Sender and event-data. There are three guidelines
regarding these parameters:

- Do not pass `null` as the sender when raising a non-static event.
- Do pass `null` as the sender when raising a static event.
- Do not pass `null` as the event-data. If no data should be passed, then `EventArgs.Empty` should be used.

This rule raises an issue when any of these guidelines is not met.

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
      class Foo
      {
        public event EventHandler ThresholdReached;
    
        protected virtual void OnThresholdReached(EventArgs e)
        {
            ThresholdReached?.Invoke(null, e); // Noncompliant
        }
      }
    }

### Compliant solution

    using System;
    
    namespace MyLibrary
    {
      class Foo
      {
        public event EventHandler ThresholdReached;
    
        protected virtual void OnThresholdReached(EventArgs e)
        {
            ThresholdReached?.Invoke(this, e);
        }
      }
    }