## Why is this an issue?

There’s no need to null test in conjunction with an `is` test. `null` is not an instance of anything, so a null check is
redundant.

### Noncompliant code example

    if (x != null && x is MyClass) { ... }  // Noncompliant
    
    if (x == null || !(x is MyClass)) { ... } // Noncompliant

### Compliant solution

    if (x is MyClass) { ... }
    
    if (!(x is MyClass)) { ... }