## Why is this an issue?

The [Attributed Programming Model](https://learn.microsoft.com/en-us/dotnet/framework/mef/attributed-programming-model-overview-mef),
also known as [Attribute-oriented programming (@OP)](https://en.wikipedia.org/wiki/Attribute-oriented_programming), is a programming model
used to embed attributes within codes.

In this model, objects are required to conform to a specific structure so that they can be used by the [Managed Extensibility Framework (MEF)](https://learn.microsoft.com/en-us/dotnet/framework/mef/).

MEF provides a way to discover available components implicitly, via **composition**. A MEF component, called a **part**,
declaratively specifies:

- both its dependencies, known as **imports**
- and what capabilities it makes available, known as **exports**

The [ExportAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.composition.exportattribute) declares that a part "exports",
or provides to the composition container, an object that fulfills a particular contract.

During composition, parts with imports that have matching contracts will have those dependencies filled by the exported object.

If the type doesn’t implement the interface it is exporting there will be an issue at runtime (either a cast exception or just a container not
filled with the exported type) leading to unexpected behaviors/crashes.

The rule raises an issue when a class doesn’t implement or inherit the type declared in the `ExportAttribute`.

## How to fix it

### Code examples

#### Noncompliant code example

    [Export(typeof(ISomeType))]
    public class SomeType // Noncompliant: doesn't implement 'ISomeType'.
    {
    }

#### Compliant solution

    [Export(typeof(ISomeType))]
    public class SomeType : ISomeType
    {
    }

## Resources

### Documentation

- [Attribute-oriented programming (@OP)](https://en.wikipedia.org/wiki/Attribute-oriented_programming)
- [Attributed Programming Model](https://learn.microsoft.com/en-us/dotnet/framework/mef/attributed-programming-model-overview-mef)
- [Managed Extensibility Framework (MEF)](https://learn.microsoft.com/en-us/dotnet/framework/mef/)
- [ExportAttribute Class](https://learn.microsoft.com/en-us/dotnet/api/system.composition.exportattribute)