## Why is this an issue?

When a collection is empty, iterating it has no effect. Doing so anyway is likely a bug; either population was accidentally omitted, or the
iteration needs to be revised.

## How to fix it

### Code examples

#### Noncompliant code example

    public void Method()
    {
        var values = new List<string>();
        values.Remove("bar");              // Noncompliant
        if (values.Contains("foo")) { }    // Noncompliant
        foreach (var str in values) { }    // Noncompliant
    }

#### Compliant solution

    public void Method()
    {
        var values = LoadValues();
        values.Remove("bar");
        if (values.Contains("foo")) { }
        foreach (var str in values) { }
    }