## Why is this an issue?

Two methods having the same implementation are suspicious. It might be that something else was intended. Or the duplication is intentional, which
becomes a maintenance burden.

    private const string CODE = "secret";
    private int callCount = 0;
    
    public string GetCode()
    {
      callCount++;
      return CODE;
    }
    
    public string GetName() // Noncompliant: duplicates GetCode
    {
      callCount++;
      return CODE;
    }

If the identical logic is intentional, the code should be refactored to avoid duplication. For example, by having both methods call the same method
or by having one implementation invoke the other.

    private const string CODE = "secret";
    private int callCount = 0;
    
    public string GetCode()
    {
      callCount++;
      return CODE;
    }
    
    public string GetName() // Intent is clear
    {
      return GetCode();
    }

### Exceptions

Empty methods, methods with only one line of code and methods with the same name (overload) are ignored.