## Why is this an issue?

Storing a value inside a collection at a given key or index and then unconditionally overwriting it without reading the initial value is a case of
a "dead store".

    list[index] = "value 1";
    list[index] = "value 2";  // Noncompliant
    
    dictionary.Add(key, "value 1");
    dictionary[key] = "value 2"; // Noncompliant

This practice is redundant and will cause confusion for the reader. More importantly, it is often an error and not what the developer intended to
do.