
There are valid cases for passing a variable multiple times into the same method call, but usually doing so is a mistake, and something else was intended for one of the arguments.

## Noncompliant Code Example


    if (Compare(point.X, point.X) != 0) // Noncompliant
    {
      //...
    }
    
    if (DoSomething(GetNextValue(), GetNextValue()))  // Noncompliant
    {
      // ...
    }


## Compliant Solution


    if (Compare(point.X, point.Y) != 0)
    {
      //...
    }
    
    var v1 = GetNextValue();
    var v2 = GetNextValue();
    if (DoSomething(v1, v2))
    {
      // ...
    }


## Deprecated

This rule is deprecated, and will eventually be removed.
