## Why is this an issue?

For clarity, all overloads of the same method should be grouped together. That lets both users and maintainers quickly understand all the current
available options.

### Noncompliant code example

    interface IMyInterface
    {
      int DoTheThing(); // Noncompliant - overloaded method declarations are not grouped together
      string DoTheOtherThing();
      int DoTheThing(string s);
    }

### Compliant solution

    interface IMyInterface
    {
      int DoTheThing();
      int DoTheThing(string s);
      string DoTheOtherThing();
    }

### Exceptions

As it is common practice to group method declarations by implemented interface, no issue will be raised for implicit and explicit interface
implementations if grouped together with other members of that interface.

As it is also a common practice to group method declarations by accessibility level, no issue will be raised for method overloads having different
access modifiers.

Example:

    class MyClass
    {
      private void DoTheThing(string s) // Ok - this method is declared as private while the other one is public
      {
        // ...
      }
    
      private string DoTheOtherThing(string s)
      {
        // ...
      }
    
      public void DoTheThing()
      {
        // ...
      }
    }