## Why is this an issue?

Operator overloading is convenient but unfortunately not portable across languages. To be able to access the same functionality from another
language you need to provide an alternate named method following the convention:

| Operator | Method Name |
| --- | --- |
| `+` (binary) | Add |
| `&` | BitwiseAnd |
| `|` | BitwiseOr |
| `/` | Divide |
| `==` | Equals |
| `^` | Xor |
| `>` | Compare |
| `>=` | Compare |
| `!=` | Equals |
| `<` | Compare |
| `<=` | Compare |
| `!` | LogicalNot |
| `%` | Mod |
| `*` (binary) | Multiply |
| `~` | OnesComplement |
| `-` (binary) | Subtract |
| `-` (unary) | Negate |
| `+` (unary) | Plus |

This rule raises an issue when there is an operator overload without the expected named alternative method.

### Exceptions

This rule does not raise an issue when the class implementing the comparison operators `>`, `<`, `>=` and
`<=` contains a method named `CompareTo`.