## Why is this an issue?

A method using the `VarArgs` calling convention is not Common Language Specification (CLS) compliant and might not be accessible across
programming languages, while the `params` keyword works the same way and is CLS compliant.

This rule raises an issue when a `public` or `protected` type contains a `public` or `protected` method
that uses the `VarArgs` calling convention.

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
        public class Foo
        {
            public void Bar(__arglist) // Noncompliant
            {
                ArgIterator argumentIterator = new ArgIterator(__arglist);
                for(int i = 0; i < argumentIterator.GetRemainingCount(); i++)
                {
                    Console.WriteLine(
                        __refvalue(argumentIterator.GetNextArg(), string));
                }
            }
        }
    }

### Compliant solution

    using System;
    
    [assembly: CLSCompliant(true)]
    namespace MyLibrary
    {
        public class Foo
        {
            public void Bar(params string[] wordList)
            {
                for(int i = 0; i < wordList.Length; i++)
                {
                    Console.WriteLine(wordList[i]);
                }
            }
        }
    }

### Exceptions

Interop methods using `VarArgs` calling convention do not raise an issue.

    [DllImport("msvcrt40.dll")]
    public static extern int printf(string format, __arglist); // Compliant