## Why is this an issue?

The .NET framework class library provides methods for retrieving custom attributes. Sealing the attribute eliminates the search through the
inheritance hierarchy, and can improve performance.

This rule raises an issue when a public type inherits from `System.Attribute`, is not abstract, and is not sealed.

### Noncompliant code example

    using System;
    
    public class MyAttribute: Attribute // Noncompliant
    {
        public string Name { get; }
    
        public MyAttribute(string name) =>
            Name = name;
    }

### Compliant solution

    using System;
    
    public sealed class MyAttribute : Attribute
    {
        public string Name { get; }
    
        public MyAttribute(string name) =>
            Name = name;
    }