## Why is this an issue?

With the advent of .NET Framework 2.0, certain practices and types have become obsolete.

In particular, exceptions should now extend `System.Exception` instead of `System.ApplicationException`. Similarly, generic
collections should be used instead of the older, non-generic, ones. Finally when creating an XML view, you should not extend
`System.Xml.XmlDocument`. This rule raises an issue when an externally visible type extends one of these types:

- [System.ApplicationException](https://learn.microsoft.com/en-us/dotnet/api/system.applicationexception)
- [System.Xml.XmlDocument](https://learn.microsoft.com/en-us/dotnet/api/system.xml.xmldocument)
- [System.Collections.CollectionBase](https://learn.microsoft.com/en-us/dotnet/api/system.collections.collectionbase)
- [System.Collections.DictionaryBase](https://learn.microsoft.com/en-us/dotnet/api/system.collections.dictionarybase)
- [System.Collections.Queue](https://learn.microsoft.com/en-us/dotnet/api/system.collections.queue)
- [System.Collections.ReadOnlyCollectionBase](https://learn.microsoft.com/en-us/dotnet/api/system.collections.readonlycollectionbase)
- [System.Collections.SortedList](https://learn.microsoft.com/en-us/dotnet/api/system.collections.sortedlist)
- [System.Collections.Stack](https://learn.microsoft.com/en-us/dotnet/api/system.collections.stack)

## How to fix it

### Code examples

#### Noncompliant code example

    using System;
    using System.Collections;
    
    namespace MyLibrary
    {
      public class MyCollection : CollectionBase  // Noncompliant
      {
      }
    }

#### Compliant solution

    using System;
    using System.Collections.ObjectModel;
    
    namespace MyLibrary
    {
      public class MyCollection : Collection<T>
      {
      }
    }