When executing an OS command and unless you specify the full path to the executable, then the locations in your application’s `PATH`
environment variable will be searched for the executable. That search could leave an opening for an attacker if one of the elements in
`PATH` is a directory under his control.

## Ask Yourself Whether

- The directories in the PATH environment variable may be defined by not trusted entities.

There is a risk if you answered yes to this question.

## Recommended Secure Coding Practices

Fully qualified/absolute path should be used to specify the OS command to execute.

## Sensitive Code Example

    Process p = new Process();
    p.StartInfo.FileName = "binary"; // Sensitive

## Compliant Solution

    Process p = new Process();
    p.StartInfo.FileName = @"C:\Apps\binary.exe"; // Compliant

## See

- OWASP - [Top 10 2021 Category A8 - Software and Data Integrity
  Failures](https://owasp.org/Top10/A08_2021-Software_and_Data_Integrity_Failures/)
- OWASP - [Top 10 2017 Category A1 - Injection](https://owasp.org/www-project-top-ten/2017/A1_2017-Injection)
- CWE - [CWE-426 - Untrusted Search Path](https://cwe.mitre.org/data/definitions/426)
- CWE - [CWE-427 - Uncontrolled Search Path Element](https://cwe.mitre.org/data/definitions/427)