## Why is this an issue?

Exceptions types should provide the following constructors:

- `public MyException()`
- `public MyException(string)`
- `public MyException(string, Exception)`

The absence of these constructors can complicate exception handling and limit the information that can be provided when an exception is thrown.

## How to fix it

### Code examples

#### Noncompliant code example

    public class MyException : Exception // Noncompliant: several constructors are missing
    {
        public MyException()
        {
        }
    }

#### Compliant solution

    public class MyException : Exception
    {
        public MyException()
        {
        }
    
        public MyException(string message)
            : base(message)
        {
        }
    
        public MyException(string message, Exception innerException)
            : base(message, innerException)
        {
        }
    }

## Resources

### Documentation

- Microsoft Learn: [How to create
  user-defined exceptions](https://learn.microsoft.com/en-us/dotnet/standard/exceptions/how-to-create-user-defined-exceptions)
- Microsoft Learn: [Exception Class](https://learn.microsoft.com/en-us/dotnet/api/system.exception)
- Microsoft Learn: [Define
  exception classes](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/exceptions/creating-and-throwing-exceptions#define-exception-classes)