## Why is this an issue?

Having a field in a child class with a name that differs from a parent class' field only by capitalization is sure to cause confusion. Such child
class fields should be renamed.

### Noncompliant code example

    public class Fruit
    {
      protected string plantingSeason;
      //...
    }
    
    public class Raspberry : Fruit
    {
      protected string plantingseason;  // Noncompliant
      // ...
    }

### Compliant solution

    public class Fruit
    {
      protected string plantingSeason;
      //...
    }
    
    public class Raspberry : Fruit
    {
      protected string whenToPlant;
      // ...
    }

Or

    public class Fruit
    {
      protected string plantingSeason;
      //...
    }
    
    public class Raspberry : Fruit
    {
      // field removed; parent field will be used instead
      // ...
    }

### Exceptions

This rule ignores same-name fields that are `static` in both the parent and child classes. It also ignores `private` parent
class fields, but in all other such cases, the child class field should be renamed.