## Why is this an issue?

By default the storage type of an `enum` is `Int32`. In most cases it is not necessary to change this. In particular you will
not achieve any performance gain by using a smaller data type (e.g. `Byte`) and may limit future uses.

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
        public enum Visibility : sbyte // Noncompliant
        {
            Visible = 0,
            Invisible = 1,
        }
    }

### Compliant solution

    using System;
    
    namespace MyLibrary
    {
        public enum Visibility
        {
            Visible = 0,
            Invisible = 1,
        }
    }