## Why is this an issue?

Type inference enables the call of a generic method without explicitly specifying its type arguments. This is not possible when a parameter type is
missing from the argument list.

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void MyMethod<T>()  // Noncompliant
        {
            // this method can only be invoked by providing the type argument e.g. 'MyMethod<int>()'
        }
      }
    }

### Compliant solution

    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void MyMethod<T>(T param)
        {
            // type inference allows this to be invoked 'MyMethod(arg)'
        }
      }
    }