## Why is this an issue?

Pointer and unmanaged function pointer types such as `IntPtr`, `UIntPtr`, `int*` etc. are used to access unmanaged
memory, usually in order to use C or C++ libraries. If such a pointer is not secured by making it `private`, `internal` or
`readonly`, it can lead to a vulnerability allowing access to arbitrary locations.

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
      public class MyClass
      {
        public IntPtr myPointer;  // Noncompliant
        protected UIntPtr myOtherPointer; // Noncompliant
      }
    }

### Compliant solution

    using System;
    
    namespace MyLibrary
    {
      public class MyClass
      {
        private IntPtr myPointer;
        protected readonly UIntPtr myOtherPointer;
      }
    }