## Why is this an issue?

Objects that can be accessed across [application
domain](https://learn.microsoft.com/en-us/dotnet/framework/app-domains/application-domains) boundaries are said to have weak identity. This means that these objects can be considered shared resources outside of the domain, which
can be lead to them being accessed or modified by multiple threads or concurrent parts of a program, outside of the domain.

A [thread](https://en.wikipedia.org/wiki/Thread_%28computing%29) acquiring a [lock](https://en.wikipedia.org/wiki/Lock_%28computer_science%29) on such an object runs the risk of being blocked by another thread in a
different application domain, leading to poor performance and potentially [thread starvation](https://stackoverflow.com/questions/1162587/what-is-starvation) and [deadlocks](https://en.wikipedia.org/wiki/Deadlock).

Types with weak identity are:

- [MarshalByRefObject](https://learn.microsoft.com/en-us/dotnet/api/system.marshalbyrefobject)
- [ExecutionEngineException](https://learn.microsoft.com/en-us/dotnet/api/system.executionengineexception)
- [OutOfMemoryException](https://learn.microsoft.com/en-us/dotnet/api/system.outofmemoryexception)
- [StackOverflowException](https://learn.microsoft.com/en-us/dotnet/api/system.stackoverflowexception)
- [String](https://learn.microsoft.com/en-us/dotnet/api/system.string)
- [MemberInfo](https://learn.microsoft.com/en-us/dotnet/api/system.reflection.memberinfo)
- [ParameterInfo](https://learn.microsoft.com/en-us/dotnet/api/system.reflection.parameterinfo)
- [Thread](https://learn.microsoft.com/en-us/dotnet/api/system.threading.thread)

## How to fix it

### Code examples

#### Noncompliant code example

    public class Sample
    {
        private readonly StackOverflowException myLock = new();
    
        public void Go()
        {
            lock (myLock) // Noncompliant
            {
                // ...
            }
        }
    }

#### Compliant solution

    public class Sample
    {
        private readonly object myLock = new();
    
        public void Go()
        {
            lock (myLock)
            {
                // ...
            }
        }
    }

## Resources

### Documentation

- [Thread](https://en.wikipedia.org/wiki/Thread_%28computing%29)
- [Locking](https://en.wikipedia.org/wiki/Lock_%28computer_science%29)
- [Deadlock](https://en.wikipedia.org/wiki/Deadlock)
- [Managed Threading Best Practices](https://docs.microsoft.com/en-us/dotnet/standard/threading/managed-threading-best-practices)
- [Application domains](https://learn.microsoft.com/en-us/dotnet/framework/app-domains/application-domains)

### Articles & blog posts

- [What is (thread) starvation?](https://stackoverflow.com/questions/1162587/what-is-starvation)
- [Readers-writers problem](https://en.wikipedia.org/wiki/Readers%E2%80%93writers_problem)
- [Dining philosophers problem](https://en.wikipedia.org/wiki/Dining_philosophers_problem)