## Why is this an issue?

String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The `System.Uri`
class is a safe alternative and should be preferred.

This rule raises an issue when two overloads differ only by the string / `Uri` parameter and the string overload doesn’t call the
`Uri` overload. It is assumed that the string parameter represents a URI because of the exact match besides that parameter type. It stands
to reason that the safer overload should be used.

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
          public void FetchResource(string uriString) // Noncompliant
          {
             // No calls to FetResource(Uri)
          }
    
          public void FetchResource(Uri uri) { }
       }
    }

### Compliant solution

    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
          public void FetchResource(string uriString)
          {
              FetchResource(new Uri(uriString));
          }
    
          public void FetchResource(Uri uri) { }
       }
    }