## Why is this an issue?

String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The `System.Uri`
class is a safe alternative and should be preferred.

This rule raises an issue when a method has a `string` return type and its name contains "Uri", "Urn", or "Url" or begins with "uri",
"urn", or "url".

### Noncompliant code example

    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
          public string GetParentUri() // Noncompliant
          {
             return "http://www.mysite.com";
          }
       }
    }

### Compliant solution

    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
    
          public Uri GetParentUri()
          {
             return new URI("http://www.mysite.com");
          }
       }
    }