## Why is this an issue?

When defining custom attributes, [AttributeUsageAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.attributeusageattribute)
must be used to indicate where the attribute can be applied. This will:

- indicate how the attribute can be used
- prevent it from being used at invalid locations

## How to fix it

### Code examples

#### Noncompliant code example

    public sealed class MyAttribute : Attribute // Noncompliant - AttributeUsage is missing
    {
        private string text;
    
        public MyAttribute(string text)
        {
            this.text = text;
        }
    
        public string Text => text;
    }

#### Compliant solution

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Enum | AttributeTargets.Interface | AttributeTargets.Delegate)]
    public sealed class MyAttribute : Attribute
    {
        private string text;
    
        public MyAttribute(string text)
        {
            this.text = text;
        }
    
        public string Text => text;
    }

## Resources

### Documentation

- Microsoft Learn - [Create custom
  attributes](https://learn.microsoft.com/en-us/dotnet/csharp/advanced-topics/reflection-and-attributes/creating-custom-attributes)
- Microsoft Learn - [AttributeUsageAttribute class](https://learn.microsoft.com/en-us/dotnet/api/system.attributeusageattribute)
- Microsoft Learn - [Attribute class](https://learn.microsoft.com/en-us/dotnet/api/system.attribute)