## Why is this an issue?

Assemblies should explicitly indicate whether they are meant to be COM visible or not. If the `ComVisibleAttribute` is not present, the
default is to make the content of the assembly visible to COM clients.

Note that COM visibility can be overridden for individual types and members.

### Noncompliant code example

    using System;
    
    namespace MyLibrary  // Noncompliant
    {
    }

### Compliant solution

    using System;
    
    [assembly: System.Runtime.InteropServices.ComVisible(false)]
    namespace MyLibrary
    {
    }