## Why is this an issue?

Creating a new [`Exception`](https://learn.microsoft.com/en-us/dotnet/api/system.exception) without actually throwing does
not achieve the intended purpose.

    if (x < 0)
    {
        new ArgumentException("x must be nonnegative");
    }

Ensure to throw the `Exception` with a [`throw`
statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/exception-handling-statements#the-throw-statement).

    if (x < 0)
    {
        throw new ArgumentException("x must be nonnegative");
    }

## Resources

### Documentation

- Microsoft Learn - [`Exception` Class](https://learn.microsoft.com/en-us/dotnet/api/system.exception)
- Microsoft Learn - [Exception-handling statements -
  `throw`, `try-catch`, `try-finally`, and `try-catch-finally`](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/exception-handling-statements)