## Why is this an issue?

The size of a collection and the length of an array are always greater than or equal to zero. Testing it doesn’t make sense, since the result is
always `true`.

    if(collection.Count >= 0){...} // Noncompliant: always true
    
    if(array.Length >= 0){...} // Noncompliant: always true

Similarly testing that it is less than zero will always return `false`.

    if(enumerable.Count() < 0){...} // Noncompliant: always false

Fix the code to properly check for emptiness if it was the intent, or remove the redundant code to keep the current behavior.