## Why is this an issue?

When the line immediately after conditional statements has neither curly braces nor indentation, the intent of the code is unclear and perhaps not
executed as expected. Additionally, such code is confusing to maintainers.

The rule will check the line indentation after the following conditional statements:

- [if and if-else
  statements](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement)
- [for
  statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement)
- [foreach
  statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-foreach-statement)
- [do statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-do-statement)
- [while
  statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-while-statement)

    if (condition)  // Noncompliant
    DoTheThing();
    DoTheOtherThing(); // Was the intent to call this function unconditionally?

It becomes even more confusing and bug-prone if lines get commented out.

    if (condition)  // Noncompliant
    //   DoTheThing();
    DoTheOtherThing(); // Was the intent to call this function conditionally?

Indentation alone or together with curly braces makes the intent clear.

    if (condition)
      DoTheThing();
    DoTheOtherThing(); // Clear intent to call this function unconditionally
    
    // or
    
    if (condition)
    {
      DoTheThing();
    }
    DoTheOtherThing(); // Clear intent to call this function unconditionally