## Why is this an issue?

Placing an `if` statement on the same line as the closing `}` from a preceding `if`, `else`, or
`else if` block can lead to confusion and potential errors. It may indicate a missing `else` statement or create ambiguity for
maintainers who might fail to understand that the two statements are unconnected.

The following code snippet is confusing:

    if (condition1) {
      // ...
    } if (condition2) {  // Noncompliant
      //...
    }

Either the two conditions are unrelated and they should be visually separated:

    if (condition1) {
      // ...
    }
    
    if (condition2) {
      //...
    }

Or they were supposed to be exclusive and you should use `else if` instead:

    if (condition1) {
      // ...
    } else if (condition2) {
      //...
    }

## Resources

### Documentation

- [If statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement)