## Why is this an issue?

Disposing an object twice in the same method, either with the [using](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/using) keyword or by calling `Dispose`
directly, is confusing and error-prone. For example, another developer might try to use an already-disposed object, or there can be runtime errors for
specific paths in the code.

In addition, even if the [documentation](https://learn.microsoft.com/en-us/dotnet/api/system.idisposable.dispose#System_IDisposable_Dispose) explicitly states that
calling the `Dispose` method multiple times should not throw an exception, some implementations still do it. Thus it is safer to not
dispose of an object twice when possible.

## How to fix it

### Code examples

#### Noncompliant code example

    var foo = new Disposable();
    foo.Dispose();
    foo.Dispose(); // Noncompliant

    using (var bar = new Disposable()) // Noncompliant
    {
        bar.Dispose();
    }

#### Compliant solution

    var foo = new Disposable();
    foo.Dispose();

    using (var bar = new Disposable()) // Compliant
    {
    
    }

## Resources

### Documentation

- [Dispose
  method](https://learn.microsoft.com/en-us/dotnet/api/system.idisposable.dispose?redirectedfrom=MSDN#System_IDisposable_Dispose)
- [DisposeAsync method](https://learn.microsoft.com/en-us/dotnet/api/system.iasyncdisposable.disposeasync)
- [Implement a Dispose method](https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/implementing-dispose)
- [Implement a DisposeAsync method](https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/implementing-disposeasync)
- [Using statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/using)