## Why is this an issue?

Numbers are infinite, but the types that hold them are not. Each numeric type has hard upper and lower bounds. Try to calculate or assign numbers
beyond those bounds, and the result will be a value that has silently wrapped around from the expected positive value to a negative one, or vice
versa.

## Noncompliant code example

    public int Transform(int value)
    {
        if (value <= 0)
        {
            return value;
        }
        int number = int.MaxValue;
        return number + value;  // Noncompliant
    }

## Compliant solution

    public long Transform(int value)
    {
        if (value <= 0)
        {
            return value;
        }
        long number = int.MaxValue;
        return number + value;
    }

## Resources

### Standards

- STIG Viewer - [Application Security and
  Development: V-222612](https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222612) - The application must not be vulnerable to overflow attacks.