## Why is this an issue?

The use of punctuation characters to separate subgroups in a number can make the number more readable. For instance consider 1,000,000,000 versus
1000000000. But when the grouping is irregular, such as 1,000,00,000; it indicates an error.

This rule raises an issue when underscores (`_`) are used to break a number into irregular subgroups.

### Noncompliant code example

    int thousand = 100_0;
    int tenThousand = 100_00;
    int million = 1_000_00_000;

### Compliant solution

    int thousand = 1000;
    int tenThousand = 10_000;
    int tenThousandWithout = 10000;
    int duos = 1_00_00;
    int million = 100_000_000;