## Why is this an issue?

Having all branches of a `switch` or `if` chain with the same implementation indicates a problem.

In the following code:

    if (b == 0)  // Noncompliant
    {
        DoTheThing();
    }
    else
    {
        DoTheThing();
    }
    
    int b = a > 12 ? 4 : 4;  // Noncompliant
    
    switch (i) // Noncompliant
    {
        case 1:
            DoSomething();
            break;
        case 2:
            DoSomething();
            break;
        case 3:
            DoSomething();
            break;
        default:
            DoSomething();
    }

Either there is a copy-paste error that needs fixing or an unnecessary `switch` or `if` chain that should be removed.

### Exceptions

This rule does not apply to `if` chains without `else`, nor to `switch` without a `default` clause.

    if (b == 0)    //no issue, this could have been done on purpose to make the code more readable
    {
        DoSomething();
    }
    else if (b == 1)
    {
        DoSomething();
    }