## Why is this an issue?

If you’re using a `struct`, it is likely because you’re interested in performance. But by failing to implement
`IEquatable<T>` you’re loosing performance when comparisons are made because without `IEquatable<T>`, boxing and
reflection are used to make comparisons.

### Noncompliant code example

    struct MyStruct  // Noncompliant
    {
        public int Value { get; set; }
    }

### Compliant solution

    struct MyStruct : IEquatable<MyStruct>
    {
        public int Value { get; set; }
    
        public bool Equals(MyStruct other)
        {
            // ...
        }
    }

## Resources

- [IEquatable&lt;T&gt; Interface](https://learn.microsoft.com/en-us/dotnet/api/system.iequatable-1)