## Why is this an issue?

`Thread.Suspend` and `Thread.Resume` can give unpredictable results, and both methods have been deprecated. Indeed, if
`Thread.Suspend` is not used very carefully, a [thread](https://en.wikipedia.org/wiki/Thread_%28computing%29) can be suspended while
holding a [lock](https://en.wikipedia.org/wiki/Lock_%28computer_science%29), thus leading to a [deadlock](https://en.wikipedia.org/wiki/Deadlock).

There are other synchronization mechanisms that are safer and should be used instead, such as:

- `Monitor` provides a mechanism that synchronizes access to objects.
- `Mutex` provides a mechanism that synchronizes interprocess access to a protected resource.
- `Semaphore` provides a mechanism that allows limiting the number of threads that have access to a protected resources concurrently.
- `Events` enable a class to notify others when something of interest occurs.

## Resources

### Documentation

- [Thread.Resume Method](https://msdn.microsoft.com/en-us/library/system.threading.thread.resume.aspx)
- [Thread.Suspend Method](https://msdn.microsoft.com/en-us/library/system.threading.thread.suspend%28v=vs.110%29.aspx)
- [Monitor Class](https://learn.microsoft.com/en-us/dotnet/api/system.threading.monitor?view=net-7.0)
- [Mutex Class](https://learn.microsoft.com/en-us/dotnet/api/system.threading.mutex?view=net-7.0)
- [Semaphore Class](https://learn.microsoft.com/en-us/dotnet/api/system.threading.semaphore?view=net-7.0)
- [Events Programming Guide](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/events/)
- [lock statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/lock)

### Articles & blog posts

- [Concurrency in C# Cookbook - Stephen Cleary](https://stephencleary.com/book/)