## Why is this an issue?

There’s no point in creating an array solely for the purpose of passing it to a `params` parameter. Simply pass the elements directly.
They will be consolidated into an array automatically.

### Noncompliant code example

    public void Base()
    {
        Method(new string[] { "s1", "s2" }); // Noncompliant: unnecessary
        Method(new string[] { });            // Noncompliant
        Method(new string[12]);              // Compliant
    }
    
    public void Method(params string[] args)
    {
        // ...
    }

### Compliant solution

    public void Base()
    {
        Method("s1", "s2");
        Method();
        Method(new string[12]);
    }
    
    public void Method(params string[] args)
    {
        // ...
    }