## Why is this an issue?

The rule is reporting when an exception is thrown from certain methods and constructors. These methods are expected to behave in a specific way and
throwing an exception from them can lead to unexpected behavior and break the calling code.

    public override string ToString()
    {
      if (string.IsNullOrEmpty(Name))
      {
        throw new ArgumentException(nameof(Name));  // Noncompliant
      }
      //...
    }

An issue is raised when an exception is thrown from any of the following:

- [ToString](https://learn.microsoft.com/en-us/dotnet/api/system.object.tostring)
- [Object.Equals](https://learn.microsoft.com/en-us/dotnet/api/system.object.equals)
- [IEquatable.Equals](https://learn.microsoft.com/en-us/dotnet/api/system.iequatable-1.equals)
- [GetHashCode](https://learn.microsoft.com/en-us/dotnet/api/system.object.gethashcode)
- [IDisposable.Dispose](https://learn.microsoft.com/en-us/dotnet/api/system.idisposable.dispose)
- [Event accessors](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/events/how-to-implement-custom-event-accessors)
- [static constructors](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/static-constructors)
- [Module initializers](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/proposals/csharp-9.0/module-initializers)
- [https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/operator-overloading](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/operator-overloading)
- [implicit cast
  operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/user-defined-conversion-operators)

### Exceptions

Certain exceptions will be ignored in specific contexts, thus not raising the issue:

- `System.NotImplementedException` and its derivatives are ignored for all the aforementioned.
- `System.InvalidOperationException`, `System.NotSupportedException`, and `System.ArgumentException` and their
  derivatives are ignored in event accessors.

## Resources

### Documentation

- [Exceptions and Exception Handling](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/exceptions/)
- [Best practices for exceptions](https://learn.microsoft.com/en-us/dotnet/standard/exceptions/best-practices-for-exceptions)
- [CA1065: Do not raise exceptions in
  unexpected locations](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1065)