## Why is this an issue?

The point of having custom exception types is to convey more information than is available in standard types. But custom exception types must be
`public` for that to work.

If a method throws a non-public exception, the best you can do on the caller’s side is to `catch` the closest `public` base
of the class. However, you lose all the information that the new exception type carries.

This rule will raise an issue if you directly inherit one of the following exception types in a non-public class:

- [Exception](https://learn.microsoft.com/en-us/dotnet/api/system.exception)
- [SystemException](https://learn.microsoft.com/en-us/dotnet/api/system.systemexception)
- [ApplicationException](https://learn.microsoft.com/en-us/dotnet/api/system.applicationexception)

## How to fix it

### Code examples

#### Noncompliant code example

    internal class MyException : Exception   // Noncompliant
    {
      // ...
    }

#### Compliant solution

    public class MyException : Exception
    {
      // ...
    }

## Resources

### Documentation

- OWASP - [Top 10 2017 Category A10 -
  Insufficient Logging & Monitoring](https://owasp.org/www-project-top-ten/2017/A10_2017-Insufficient_Logging%2526Monitoring)
- [Exception](https://learn.microsoft.com/en-us/dotnet/api/system.exception)
- [SystemException](https://learn.microsoft.com/en-us/dotnet/api/system.systemexception)
- [ApplicationException](https://learn.microsoft.com/en-us/dotnet/api/system.applicationexception)
- [Access modifiers](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/access-modifiers)
- [Exceptions and Exception Handling](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/exceptions)