## Why is this an issue?

Fields, properties and events can be initialized either inline or in the constructor. Initializing them inline and in the constructor at the same
time is redundant; the inline initialization will be overridden.

### Noncompliant code example

    class Person
    {
      int age = 42; // Noncompliant
      public Person(int age)
      {
        this.age = age;
      }
    }

### Compliant solution

    class Person
    {
      int age;
      public Person(int age)
      {
        this.age = age;
      }
    }

### Exceptions

This rule doesn’t report an issue if not all constructors initialize the field. If the field is initialized inline to its default value, then
{rule:csharpsquid:S3052} already reports an issue on the initialization.