## Why is this an issue?

Marking a method with the [`Pure`](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.contracts.pureattribute)
attribute indicates that the method doesn’t make any visible state changes. Therefore, a `Pure` method should return a result. Otherwise,
it indicates a no-operation call.

Using `Pure` on a `void` method is either by mistake or the method is not doing a meaningful task.

## How to fix it

### Code examples

#### Noncompliant code example

    class Person
    {
      private int age;
    
      [Pure] // Noncompliant: The method makes a state change
      void ConfigureAge(int age) =>
        this.age = age;
    }

#### Compliant solution

    class Person
    {
      private int age;
    
      void ConfigureAge(int age) =>
        this.age = age;
    }

## Resources

### Documentation

- Microsoft Learn - [PureAttribute Class](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.contracts.pureattribute)