## Why is this an issue?

Adding [params](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/params) to a method override has no effect.
The compiler accepts it, but the callers won’t be able to benefit from the added modifier.

### Noncompliant code example

    class Base
    {
      public virtual void Method(int[] numbers)
      {
        ...
      }
    }
    class Derived : Base
    {
      public override void Method(params int[] numbers) // Noncompliant, method can't be called with params syntax.
      {
        ...
      }
    }

### Compliant solution

    class Base
    {
      public virtual void Method(int[] numbers)
      {
        ...
      }
    }
    class Derived : Base
    {
      public override void Method(int[] numbers)
      {
        ...
      }
    }

## Resources

### Documentation

- [params keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/params)