## Why is this an issue?

When declaring a Windows Communication Foundation (WCF) [`OperationContract`](https://learn.microsoft.com/en-us/dotnet/api/system.servicemodel.operationcontractattribute?view=dotnet-plat-ext-7.0)
method as [`one-way`](https://learn.microsoft.com/en-us/dotnet/api/system.servicemodel.operationcontractattribute.isoneway?view=dotnet-plat-ext-7.0),
that service method won’t return any result, not even an underlying empty confirmation message. These are fire-and-forget methods that are useful in
event-like communication. Therefore, specifying a return type has no effect and can confuse readers.

### Exceptions

The rule doesn’t report if [`OperationContractAttribute.AsyncPattern`](https://learn.microsoft.com/en-us/dotnet/api/system.servicemodel.operationcontractattribute.asyncpattern)
is set to `true`.

## How to fix it

### Code examples

#### Noncompliant code example

    [ServiceContract]
    interface IMyService
    {
      [OperationContract(IsOneWay = true)]
      int SomethingHappened(int parameter); // Noncompliant
    }

#### Compliant solution

    [ServiceContract]
    interface IMyService
    {
      [OperationContract(IsOneWay = true)]
      void SomethingHappened(int parameter);
    }

## Resources

### Documentation

Microsoft Learn - [OperationContractAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.servicemodel.operationcontractattribute)