## Why is this an issue?

The `default` clause should take appropriate action. Having an empty `default` is a waste of keystrokes.

### Noncompliant code example

    enum Fruit
    {
      Apple,
      Orange,
      Banana
    }
    
    void PrintName(Fruit fruit)
    {
      switch(fruit)
      {
        case Fruit.Apple:
          Console.WriteLine("apple");
          break;
        default:  //Noncompliant
          break;
      }
    }

### Compliant solution

    enum Fruit
    {
      Apple,
      Orange,
      Banana
    }
    
    void PrintName(Fruit fruit)
    {
      switch(fruit)
      {
        case Fruit.Apple:
          Console.WriteLine("apple");
          break;
        default:
          throw new NotSupportedException();
      }
    }

or

    void PrintName(Fruit fruit)
    {
      switch(fruit)
      {
        case Fruit.Apple:
          Console.WriteLine("apple");
          break;
      }
    }

### Exceptions

`default` clauses containing only a comment are ignored with the assumption that they are empty on purpose and the comment documents
why.