## Why is this an issue?

Numbers can be shifted with the `<<` and `>>` [operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators#left-shift-operator-),
but the right operand of the operation needs to be an `int` or a type that has an [implicit
conversion](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/language-specification/conversions#102-implicit-conversions) to `int`. However, when the left operand is [dynamic](https://learn.microsoft.com/en-us/dotnet/csharp/advanced-topics/interop/using-type-dynamic), the compiler’s type checking is turned
off, so you can pass anything to the right of a shift operator and have it compile. And if the argument can’t be implicitly converted to
`int` at runtime, then a [RuntimeBinderException](https://learn.microsoft.com/en-us/dotnet/api/microsoft.csharp.runtimebinder.runtimebinderexception) will be
raised.

    dynamic d = 5;
    var x = d >> 5.4;   // Noncompliant
    x = d << null;      // Noncompliant
    x <<= new object(); // Noncompliant

## Resources

### Documentation

- [Shift
  Operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators#left-shift-operator-)
- [Implicit
  Conversions](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/language-specification/conversions#102-implicit-conversions)
- [RuntimeBinderException Class](https://learn.microsoft.com/en-us/dotnet/api/microsoft.csharp.runtimebinder.runtimebinderexception)
- [Using type dynamic](https://learn.microsoft.com/en-us/dotnet/csharp/advanced-topics/interop/using-type-dynamic)