## Why is this an issue?

The [abstract](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/abstract) modifier in a class declaration is
used to indicate that a class is intended only to be a base class of other classes, not instantiated on its own.

Since `abstract` classes cannot be instantiated, there is no need for `public` or `internal` constructors. If
there is basic initialization logic that should run when an extending class instance is created, you can add it in a `private`,
`private protected` or `protected` constructor.

## How to fix it

Restrict the constructor visibility to the minimum: `private`, `private protected` or `protected`, depending on
the usage.

### Code examples

#### Noncompliant code example

    abstract class Base
    {
        public Base() // Noncompliant: should be private, private protected or protected.
        {
          //...
        }
    }

#### Compliant solution

    abstract class Base
    {
        protected Base()
        {
          //...
        }
    }

## Resources

### Documentation

- [abstract keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/abstract)
- [abstract type](https://en.wikipedia.org/wiki/Abstract_type)