## Why is this an issue?

There’s no point in checking a variable against the value you’re about to assign it. Save the cycles and lines of code, and simply perform the
assignment.

### Noncompliant code example

    if (x != a)  // Noncompliant; why bother?
    {
        x = a;
    }

### Compliant solution

    x = a;

### Exceptions

Properties and checks inside setters are excluded from this rule because they could have side effects and removing the check could lead to
undesired side effects.

    if (MyProperty != a)
    {
        MyProperty = a; // Compliant because the setter could be expensive call
    }

    private int myField;
    public int SomeProperty
    {
        get
        {
            return myField;
        }
        set
        {
            if (myField != value)
            {
                myField = value;
            }
        }
    }