## Why is this an issue?

A method is identified as a test method if it is marked with one of the following attributes:

- `[TestMethod]` or `[DataTestMethod]` (for **MSTest**).
- `[Fact]` or `[Theory]` (for **xUnit**).
- `[Test]`, `[TestCase]`, `[TestCaseSource]`, or `[Theory]` (for **NUnit**).

However, non-`public` methods are not considered test methods and will not be executed, regardless of whether they have a test
attribute. Additionally, methods with the `async void` modifier or methods that contain generics `<T>` anywhere in their
signatures are also excluded from being recognized as tests and will not be executed.

    [TestMethod]
    void TestNullArg()  // Noncompliant, method is not public
    {  /* ... */  }
    
    [TestMethod]
    public async void MyIgnoredTestMethod()  // Noncompliant, this is an 'async void' method
    { /* ... */ }
    
    [TestMethod]
    public void MyIgnoredGenericTestMethod<T>(T foo)  // Noncompliant, method has generics in its signature
    { /* ... */ }

    [TestMethod]
    public void TestNullArg()
    {  /* ... */  }
    
    [TestMethod]
    public async Task MyIgnoredTestMethod()
    { /* ... */ }
    
    [TestMethod]
    public void MyIgnoredGenericTestMethod(int foo)
    { /* ... */ }

### Exceptions

For **xUnit**, accessibility is disregarded when it comes to `[Fact]` test methods, as they do not necessarily need to be
declared as `public`.

In **xUnit**, `[Theory]` test methods, as well as `[TestCase]` and `[TestCaseSource]` test methods in
**NUnit**, have the flexibility to be generic, allowing for a wider range of test scenarios.

## Resources

### Documentation

- [Unit testing C# with MSTest](https://learn.microsoft.com/en-us/dotnet/core/testing/unit-testing-with-mstest)
- [Unit testing C# with NUnit](https://learn.microsoft.com/en-us/dotnet/core/testing/unit-testing-with-nunit)
- [Unit testing C# with xUnit](https://learn.microsoft.com/en-us/dotnet/core/testing/unit-testing-with-dotnet-test)