## Why is this an issue?

The standard assertions library methods such as `AreEqual` and `AreSame` in **MSTest** and
**NUnit**, or `Equal` and `Same` in **XUnit**, expect the first argument to be the expected value and
the second argument to be the actual value.

### What is the potential impact?

Having the expected value and the actual value in the wrong order will not alter the outcome of tests, (succeed/fail when it should) but the error
messages will contain misleading information.

This rule raises an issue when the actual argument to an assertions library method is a hard-coded value and the expected argument is not.

## How to fix it

You should provide the assertion methods with a hard-coded value as the expected value, while the actual value of the assertion should derive from
the portion of code that you want to test.

### Code examples

#### Noncompliant code example

    Assert.AreEqual(runner.ExitCode, 0, "Unexpected exit code"); // Noncompliant; Yields error message like: Expected:<-1>. Actual:<0>.

#### Compliant solution

    Assert.AreEqual(0, runner.ExitCode, "Unexpected exit code");