## Why is this an issue?

There’s no point in forcing the overhead of a method call for a method that always returns the same constant value. Even worse, the fact that a
method call must be made will likely mislead developers who call the method thinking that something more is done. Declare a constant instead.

This rule raises an issue if on methods that contain only one statement: the `return` of a constant value.

### Noncompliant code example

    int GetBestNumber()
    {
      return 12;  // Noncompliant
    }

### Compliant solution

    const int BestNumber = 12;

or

    static readonly int BestNumber = 12;