## Why is this an issue?

When a `private static` method is only invoked by a nested class, there’s no reason not to move it into that class. It will still have
the same access to the outer class' static members, but the outer class will be clearer and less cluttered.

### Noncompliant code example

    public class Outer
    {
        private const int base = 42;
    
        private static void Print(int num)  // Noncompliant - static method is only used by the nested class, should be moved there
        {
            Console.WriteLine(num + base);
        }
    
        public class Nested
        {
            public void SomeMethod()
            {
                Outer.Print(1);
            }
        }
    }

### Compliant solution

    public class Outer
    {
        private const int base = 42;
    
        public class Nested
        {
            public void SomeMethod()
            {
                Print(1);
            }
    
            private static void Print(int num)
            {
                Console.WriteLine(num + base);
            }
        }
    }