## Why is this an issue?

Nested ternaries are hard to read and can make the order of operations complex to understand.

    public string GetReadableStatus(Job j)
    {
      return j.IsRunning ? "Running" : j.HasErrors ? "Failed" : "Succeeded";  // Noncompliant
    }

Instead, use another line to express the nested operation in a separate statement.

    public string GetReadableStatus(Job j)
    {
      if (j.IsRunning)
      {
        return "Running";
      }
      return j.HasErrors ? "Failed" : "Succeeded";
    }